---
date created: 2025-10-22T21:52
date modified: 2026-01-24T00:35
---
> **🔄 Last Updated: 2026-01-24** | Backup: `00. Inbox/03. AI Agent/cmds-system-files/CMDS_backup.md`

# CMDS.md

This file provides LLM assistants with essential context about the CMDS (커맨드스페이스) Personal Knowledge Management system created by 구요한(Yohan Koo). Use this document to understand the user's knowledge management philosophy, workflow, and context.

---

## System Documentation Overview

This vault has **5 core system files** that complement each other. You are currently reading the **context guide**.

### The 5 Core Files

**🤖 AI Documents** (loaded into context window):

| File                    | Your Use Case                          | Key Content                                      |
| ----------------------- | -------------------------------------- | ------------------------------------------------ |
| **CMDS.md** (this file) | Understanding WHY & WHAT               | User profile, system philosophy, workflows       |
| **CLAUDE.md**           | Technical implementation (Claude Code) | Claude Code specific rules, commands             |
| **AGENTS.md**           | Technical implementation (Other AI)    | Gemini CLI, Codex, Cursor, etc.                  |

**👤 Human Documents** (referenced in Obsidian):

| File                        | Your Use Case      | Key Content                         |
| --------------------------- | ------------------ | ----------------------------------- |
| **🏛 CMDS Head Quarter.md** | Quick navigation   | 91 category links, GPT links        |
| **🏛 CMDS Guide.md**        | Standards reference | Properties templates, naming rules  |

### When to Reference Each File

**Start here (CMDS.md) when**:
- First time working with this vault
- Need to understand user's (구요한) work context
- Want to know the PURPOSE of each category (100-900)
- Learning about CMDS Process (Connect → Merge → Develop → Share)

**Reference CLAUDE.md when**:
- Claude Code is writing or modifying code
- Need Claude-specific technical specs

**Reference AGENTS.md when**:
- Other AI coding agents (Gemini CLI, Codex) working with vault
- Need general technical specs without Claude-specific content

**Reference 🏛 CMDS Head Quarter.md when**:
- Need the full category structure at a glance
- Looking for ChatGPT GPT links

**Reference 🏛 CMDS Guide.md when**:
- Creating new notes (need Properties template)
- Checking standard note types or naming conventions

### Quick Decision Tree

```
Are you trying to...
├─ Understand the system? → CMDS.md (you are here)
├─ Write code (Claude Code)? → CLAUDE.md
├─ Write code (Other AI)? → AGENTS.md
├─ Navigate to a category? → 🏛 CMDS Head Quarter.md
└─ Check standards/templates? → 🏛 CMDS Guide.md
```

**This file provides the "story" behind the system. For technical "how-to", see CLAUDE.md or AGENTS.md.**

---

## What is CMDS?

**CMDS (커맨드스페이스)** is a comprehensive Personal Knowledge Management (PKM) system built on Obsidian, designed to transform raw information into actionable knowledge and creative outputs. It's not just a filing system—it's a living ecosystem where ideas connect, merge, develop, and share.

### Core Philosophy

1. **Knowledge as a Network**: Every note is a node in an interconnected web of knowledge
2. **Process-Driven**: Knowledge flows through distinct stages (Connect → Merge → Develop → Share)
3. **AI-Enhanced**: Integrated with multiple AI tools (ChatGPT, Claude, Midjourney, etc.)
4. **Output-Focused**: Knowledge exists to be transformed into tangible outputs (research, lectures, consulting, creative works)
5. **Personal yet Structured**: Flexible enough for creativity, structured enough for productivity

---

## The User: 구요한 (Yohan Koo)

### Professional Identity
- **PhD Candidate** in Educational Technology/Knowledge Management
- **Knowledge Management Specialist**: Second Brain, Zettelkasten, PKM systems
- **Generative AI Expert**: ChatGPT, Claude, prompt engineering, AI education
- **Educator**: University lecturer, workshop facilitator, curriculum developer
- **Consultant**: AI transformation, knowledge management, educational innovation
- **Creative Professional**: YouTube creator, music producer, digital artist

### Work Context
구요한 operates **9 professional divisions** (📖 900 Divisions):
1. **Knowledge Management & Research** (901)
2. **Editorial & Content Creation** (902)
3. **Education & Training** (903)
4. **Creative Arts & Media** (904)
5. **Data Science & Analytics** (905)
6. **Partnerships & Outreach** (906)
7. **Technology & Development** (907)
8. **Events & Community Engagement** (908)
9. **Consulting & Professional Services** (909)

### Primary Activities
- Conducting PhD research on knowledge management and AI
- Teaching university courses on AI, research methods, knowledge management
- Consulting with corporations on AI transformation and knowledge management
- Creating educational content (YouTube, articles, courses)
- Managing multiple projects simultaneously across different domains
- Building and maintaining a 5,344+ note knowledge base

---

## CMDS Architecture: 9 Categories (100-900 Series)

The CMDS system organizes all knowledge into 9 major categories, each representing a distinct stage or aspect of the knowledge lifecycle.

### 📖 100 Themes — Discovery & Connection
**Purpose**: Capture emerging interests, topics, variables, and terminologies
**Contains**:
- 📚 101 Interests — Personal and professional interests
- 📚 102 Topics — Subjects being explored
- 📚 103 Variables — Research variables, concepts to operationalize
- 📚 104 Terminologies — Definitions and vocabulary

**Role in Workflow**: This is where curiosity lives. New ideas, unfamiliar terms, and potential research topics are captured here before they mature into full concepts.

### 📖 200 Literature — Integration & Theory
**Purpose**: Integrate knowledge from external sources into personal understanding
**Contains**:
- 📚 201 Concepts — Core conceptual frameworks
- 📚 202 Frameworks — Theoretical frameworks and models
- 📚 203 Models — Analytical and conceptual models
- 📚 204 Theories — Established theories
- 📚 205 Classics — Foundational texts and seminal works
- 📚 210 Literature Reviews — Academic literature synthesis
- 📚 220 Personal Insights — Original interpretations and connections
- 📚 240 Books — Book notes and reviews
- 📚 290 Bible — Biblical texts and theology
- 📚 291 Sermon — Sermon notes and spiritual reflections

**Role in Workflow**: Raw ideas from 100 Themes are enriched with literature, transformed into robust theoretical foundations. This is where learning happens.

### 📖 300 Data — Collection & Management
**Purpose**: Manage research data, surveys, and information systems
**Contains**:
- 📚 301 Scale Development and Validation
- 📚 302 Questionnaires — Survey instruments
- 📚 303 Panel Data — Longitudinal data
- 📚 310 Data Management — Data organization and workflows
- 📚 311 Database Systems — Database design and implementation
- 📚 330 Learning Management Systems — LMS platforms and usage

**Role in Workflow**: Theoretical knowledge from 200 Literature is operationalized into measurable data. This is where theory meets empirical reality.

### 📖 400 Methodologies — Analysis & Implementation
**Purpose**: Apply research methods, statistical techniques, and analytical approaches
**Contains**:
- 📚 401 Research Methods — Research design principles
- 📚 402 Quantitative Research
- 📚 403 Experimental Research
- 📚 404 Qualitative Research
- 📚 405 Mixed Methods
- 📚 410 Statistical Inference
- 📚 411 Regression Analysis
- 📚 412 Causal Inference
- 📚 420 Machine Learning
- 📚 421 Time Series Analysis
- 📚 422 Deep Learning
- 📚 423 Predictive Analytics
- 📚 490 Syntax — Statistical software syntax
- 📚 491 Codes — Programming code snippets
- 📚 492 Prompts — AI prompts and templates
- 📚 493 Scripts — Automation scripts

**Role in Workflow**: Data from 300 is analyzed using appropriate methods. This is where insights are generated through systematic analysis.

### 📖 500 Products — Tools & Platforms
**Purpose**: Master and leverage productivity tools and AI platforms
**Contains**:
- 📚 501 Obsidian — PKM system mastery
- 📚 502 Notion — Project management
- 📚 510 DevonThink — Document management
- 📚 520 ChatGPT — AI assistance and automation
- 📚 521 Claude — AI writing and analysis
- 📚 522 Gemini — Google AI tools
- 📚 523 LLaMa — Open-source LLMs
- 📚 530 Midjourney — AI image generation
- 📚 531 Stable Diffusion — Image AI
- 📚 541 n8n — Workflow automation

**Role in Workflow**: Tools are not just used—they are studied, mastered, and integrated into workflows. This category captures tool knowledge and best practices.

### 📖 600 Specialties — Expertise & Application
**Purpose**: Develop deep expertise in specialized domains
**Contains**:
- 📚 601 Knowledge Management — PKM theory and practice
- 📚 603 Second Brain — Building a Second Brain methodology
- 📚 604 ZettelKasten — Zettelkasten method
- 📚 610 Productivity — Personal productivity systems
- 📚 620 Generative AI — AI applications and education
- 📚 630 Development — Software development
- 📚 651 Physical Health — Exercise and wellness
- 📚 652 Mental Health — Psychology and well-being
- 📚 653 Biohacking — Performance optimization
- 📚 680 Educations — Educational theory and practice
- 📚 690 Spirituality — Faith and spiritual growth

**Role in Workflow**: This is where 구요한 develops and maintains professional expertise. It's a combination of theory (200), methods (400), and practical experience.

### 📖 700 Creatives — Expression & Content
**Purpose**: Create and distribute creative content across multiple platforms
**Contains**:
- 📚 701 YouTube — Video content creation
- 📚 710 SNS — Social media content
- 📚 720 Music — Music composition and production
- 📚 721 Jazz — Jazz theory and performance
- 📚 730 Images — Visual content
- 📚 731 Digital Art and Design — AI-generated art, design work

**Role in Workflow**: Knowledge and expertise are transformed into creative expressions. This is where ideas become content.

### 📖 800 Outputs — Publication & Delivery
**Purpose**: Produce and deliver formal outputs (academic, professional, educational)
**Contains**:
- 📚 801 PhD — Doctoral dissertation and research
- 📚 802 Articles — Published articles and essays
- 📚 803 Books — Book manuscripts
- 📚 804 Community — Community building and engagement
- 📚 805 Group Study — Study groups and cohorts
- 📚 806 Webpages — Web content and sites
- 📚 820 Research — Research projects
- 📚 821 Academic Journals — Journal publications
- 📚 822 Conference Presentations — Academic presentations
- 📚 830 Projects — Client projects
- 📚 831 Consulting — Consulting deliverables
- 📚 840 Lectures — Teaching materials
- 📚 841 Curriculum — Course design
- 📚 842 Course Development and Resources — Educational resources
- 📚 843 Class Administration and Management — Teaching operations

**Role in Workflow**: This is the ultimate destination—where all prior work (Connect, Merge, Develop) culminates in tangible outputs that serve others.

### 📖 900 Divisions — Operations & Management
**Purpose**: Organize and manage the operational structure of 구요한's professional activities
**Contains**:
- 📚 901 Knowledge Management & Research Division
- 📚 902 Editorial & Content Creation Division
- 📚 903 Education & Training Division
- 📚 904 Creative Arts & Media Division
- 📚 905 Data Science & Analytics Division
- 📚 906 Partnerships & Outreach Division
- 📚 907 Technology & Development Division
- 📚 908 Events & Community Engagement Division
- 📚 909 Consulting & Professional Services Division

**Role in Workflow**: Meta-organizational layer that manages how all other categories are operationalized in 구요한's professional life.

---

## CMDS Process: The Knowledge Lifecycle

The CMDS framework is not just a filing system—it's a **process** that guides knowledge through four distinct stages.

### 🔗 Connect — Idea Discovery (100 Themes)
**What happens**: Encounter new ideas, capture interests, identify gaps
**Questions to ask**:
- What am I curious about?
- What terminology do I need to learn?
- What topics are emerging in my field?
- What variables matter for my research?

**Outputs**: Notes in 100 Themes (interests, topics, variables, terminologies)

### 🔀 Merge — Knowledge Integration (200 Literature)
**What happens**: Read literature, connect ideas, build theoretical frameworks
**Questions to ask**:
- How does this concept relate to what I already know?
- What do scholars say about this topic?
- What frameworks exist to explain this phenomenon?
- What are my own insights and interpretations?

**Outputs**: Literature notes, concept maps, theoretical frameworks, personal insights

### 🛠 Develop — Application & Creation (300-600)
**What happens**: Collect data, apply methods, use tools, build expertise
**Questions to ask**:
- What data do I need?
- Which methods are appropriate?
- What tools will help me execute?
- How do I deepen my expertise in this area?

**Outputs**: Datasets, analysis scripts, tool mastery notes, domain expertise

### 📤 Share — Output & Impact (700-800)
**What happens**: Create content, publish research, teach, consult, serve others
**Questions to ask**:
- How can I share this knowledge?
- Who needs this information?
- What format will be most impactful?
- How can I help others learn and grow?

**Outputs**: YouTube videos, articles, research papers, lectures, consulting projects, creative works

---

## Note Hierarchy & Navigation

### Hierarchical Structure
```
🏛 Home/Guide (최상위)
└── 📖 1st Level CMDS (100-900 시리즈)
    └── 📚 2nd Level CMDS (N01-N99)
        └── (No Icon) 3rd Level Notes (세부 주제)
```

### Key Hub Notes
- **[[🏛 CMDS Head Quarter]]** — Central navigation hub, links to all 9 categories
- **[[🏛 CMDS Guide]]** — Properties standards, naming conventions, operational guidelines
- **[[🏛 000 YHN Home]]** — Personal home page

### Index Notes (🏷)
Index notes aggregate related content across categories:
- [[🏷 Daily Notes]] — Daily journal entries
- [[🏷 Meeting Notes]] — Meeting minutes
- [[🏷 Research Notes]] — Research documentation
- [[🏷 Lecture Notes]] — Teaching materials
- [[🏷 People]] — People profiles
- [[🏷 Prompts]] — AI prompt library
- [[🏷 Syntax and Codes]] — Code snippets

---

## Note Properties & Metadata

Every note in CMDS contains structured metadata that enables powerful queries and connections.

### Required Properties (6 fields)
```yaml
---
type:           # Note category (see types below)
aliases: []     # Alternative names
author:
  - "[[구요한]]"
date created:   # YYYY-MM-DD
date modified:  # YYYY-MM-DD
tags: []        # Topical tags
---
```

### Common Note Types
**Content Types**:
- `note` — General knowledge notes (142+)
- `terminology` — Term definitions (101+)
- `books` — Book notes and reviews
- `article` — Articles and essays
- `research-review` — Literature reviews
- `sermon` — Spiritual reflections

**Structural Types**:
- `CMDS` — Category index pages (replaces traditional MOC concept)
- `index` — Collection pages

**Activity Types**:
- `meeting` — Meeting minutes (80+)
- `people` — People profiles (59+)
- `curriculum` — Course curricula (36+)
- `project` — Project documentation

### Status Values
- `unread` — Not yet processed
- `reading` — Currently reading/processing
- `inProgress` — Active work in progress
- `completed` — Finished
- `archived` — Historical reference

---

## Workflow Patterns & Common Scenarios

### Research Workflow
1. **Discover** a research question → Capture in [[📚 102 Topics]]
2. **Define** key variables → Document in [[📚 103 Variables]]
3. **Review** literature → Create notes in [[📚 210 Literature Reviews]]
4. **Design** study → Plan in [[📚 401 Research Methods]]
5. **Collect** data → Manage in [[📚 310 Data Management]]
6. **Analyze** → Apply methods from [[📚 410 Statistical Inference]]
7. **Write** → Draft in [[📚 821 Academic Journals]]
8. **Present** → Prepare in [[📚 822 Conference Presentations]]

### Teaching Workflow
1. **Design** curriculum → Create in [[📚 841 Curriculum]]
2. **Develop** resources → Build in [[📚 842 Course Development and Resources]]
3. **Prepare** lectures → Store in [[📚 840 Lectures]]
4. **Teach** → Document in [[🏷 Daily Notes]]
5. **Reflect** → Write insights in [[📚 220 Personal Insights]]

### Consulting Workflow
1. **Meet** with client → Record in [[🏷 Meeting Notes]]
2. **Research** client's needs → Reference [[📚 601 Knowledge Management]] or [[📚 620 Generative AI]]
3. **Design** solution → Draft in [[📚 831 Consulting]]
4. **Deliver** → Present and document in [[📚 830 Projects]]
5. **Follow up** → Track in [[60. Collections/63. Meetings/]]

### Content Creation Workflow
1. **Identify** topic from [[📚 102 Topics]] or [[📚 220 Personal Insights]]
2. **Research** using [[📖 200 Literature]] notes
3. **Script** content using [[📚 492 Prompts]] and AI tools
4. **Create** in appropriate platform (YouTube, article, etc.)
5. **Publish** and document in [[📚 701 YouTube]] or [[📚 802 Articles]]

---

## AI Integration in CMDS

### AI Tools Used Daily
- **ChatGPT** (Custom GPTs): CMDS GPT-5 Pro, o3-pro, GPT-5 Thinking, o3
- **Claude** (via Claude Code): Code generation, analysis, writing assistance
- **Midjourney/Stable Diffusion**: Visual content creation
- **n8n**: Workflow automation
- **Obsidian AI Plugins**: Copilot, Smart Connections

### Custom AI Assistants
구요한 maintains custom GPT assistants linked in [[🏛 CMDS Head Quarter]]:
- **CMDS GPT-5 Pro** — Primary assistant for knowledge work
- **CMDS o3-pro** — Advanced reasoning and analysis
- **CMDS GPT-5 Thinking** — Deep thinking and problem-solving
- **CMDS o3** — Alternative reasoning model

### AI-Generated Content
- **Prompts Library**: [[📚 492 Prompts]] — Reusable prompt templates
- **Code Snippets**: [[📚 491 Codes]] — AI-generated and human-curated code
- **System Prompts**: `90. Settings/94. System Prompts/` — Custom instructions for AI assistants

---

## Key Directories & Their Roles

### 00. Inbox/ — Processing Area
**Purpose**: Temporary storage for new inputs before they're processed into the CMDS system
- `01. Daily Notes/` — Daily reflections and logs (with 01-1. Planners, 01-2. Weekly Notes)
- `02. Clippings/` — Web clippings (with 02-1. Literature Notes)
- `03. AI Agent/` — **PRIMARY WORKING DIRECTORY** for all AI coding outputs (Claude Code, etc.)
- `04. Excalidraw/` — Visual diagrams
- `05. Canvas/` — Canvas notes
- `06. Automation/` — Automation workflows (06-1. Make.com, 06-2. n8n Lecture, 06-3. STT)
- `07. App Sync/` — External app sync (07-1. Claude, 07-2. Antigravity, 07-3. Bear Notes)
- `08. Unlisted/` — Unlisted items
- `09. Legacy/` — Legacy and archived content

**Workflow**: Items in Inbox are temporary. They should be processed and moved to appropriate CMDS categories.

### 10. CMDS Process/ — Process Documentation
Documents the **Connect → Merge → Develop → Share** workflow itself
- `11. Connect/` — Capturing and connecting ideas
- `12. Merge/` — Integrating knowledge
- `13. Develop/` — Building and creating
- `14. Share/` — Publishing and sharing

### 20. Literature Notes/ — Reading Notes
Notes from books, articles, papers (usually migrate to [[📖 200 Literature]] categories)

### 30. Permanent Notes/ — Evergreen Content
Fully developed, timeless notes that represent mature knowledge

### 40. Docs/ — Technical Documentation
**Purpose**: Central repository for technical documents and guides
- `41. Official Docs/` — Official documentation, API guides, product manuals
- `42. AI Generated/` — AI-generated technical documents and tutorials
- `43. My Docs/` — User-created technical documents and specifications

**Workflow**: Reference materials for development, implementation guides, and technical knowledge. Distinct from 80. References (academic/research focus) - this is practical, implementation-focused documentation.

### 60. Collections/ — Entity Management
- `61. People/` — People database
- `62. Organization/` — Organizations
- `63. Meetings/` — Meeting archives
- `64. Spirituality/` — Spiritual content (Bible, sermons)
- `67. Bases/` — Database structures
- `68. Kanban Board/` — Kanban boards
- `69. Preferences/` — User preferences (Alcohol, Coffee, etc.)

### 70. Outputs/ — Final Deliverables
- `71. Published/` — Published content
- `72. Presentations/` — Presentation materials
- `73. Courses/` — Course content
	- `73-1. Curriculum/` — Course materials (from 60. Collections)
	- `73-2. Class/` — Class management (from 60. Collections)
	- `임원 AI 교육 모듈/` — Executive AI training modules
- `74. Projects/` — Project documentation
- `75. Consulting/` — Consulting deliverables
- `79. Portfolio/` — Portfolio pages

### 80. References/ — External Materials
- `81. Attachment/` — File attachments
- `82. Web Articles/` — Web articles
- `83. References/` — General references
- `84. References (Zotero)/` — Zotero references
- `85. References (Book)/` — Book references
- `86. Omnivore/` — Omnivore articles
- `86. References (Book, Yes24)/` — Yes24 books

### 90. Settings/ — System Configuration
- `91. Templates/` — Note templates
- `92. Templates (archived)/` — Archived templates
- `93. Generated Text/` — AI generated text
- `94. System Prompts/` — AI assistant instructions
- `95. Fonts/` — Font files
- `96. Index/` — Index files
- `97. File Class/` — File classification
- `98. Format/` — Format definitions
- `99. Others/` — Other settings

---

## Common Terminology & Concepts

### PKM Terms
- **Second Brain**: External system for storing and organizing knowledge (Tiago Forte's methodology)
- **Zettelkasten**: Note-taking method focused on atomic notes and connections
- **Evergreen Notes**: Timeless, fully developed notes that don't decay
- **CMDS Index**: Category index pages that organize related notes (replaces traditional MOC concept in this vault)
- **Atomic Notes**: Small, focused notes on single concepts
- **Progressive Summarization**: Highlighting and condensing information in stages

### CMDS-Specific Terms
- **CMDS Process**: Connect → Merge → Develop → Share workflow
- **Space Collection**: First-level CMDS categories (100-900)
- **Spaces**: Second-level CMDS categories (N01-N99)
- **Hub Notes**: 🏛 notes that serve as navigation centers
- **Index Notes**: 🏷 notes that aggregate related content

### File Prefix Meanings
- 📎 — Web Clips (captured from web)
- 🏷 — Index pages (collections)
- 📦 — Reviews (analyzed content)
- 🔖 — Personal outputs (구요한's original ideas)
- 📜 — Others' outputs (curated external content)
- 📈 — Code and syntax (technical content)
- 🎹 — Music (compositions, theory)
- 📘 — Books and references

---

## Understanding User Intent

When 구요한 asks you to work with the vault, understand the context:

### Research Context
If discussing research topics:
- Connect to PhD work ([[📚 801 PhD]])
- Reference relevant literature ([[📖 200 Literature]])
- Consider methodological approaches ([[📖 400 Methodologies]])
- Think about potential publications ([[📚 821 Academic Journals]])

### Teaching Context
If discussing courses or lectures:
- Reference curriculum designs ([[📚 841 Curriculum]])
- Link to relevant subject expertise ([[📖 600 Specialties]])
- Consider student learning outcomes
- Think about course materials ([[📚 842 Course Development and Resources]])

### Consulting Context
If discussing client work:
- Document in meetings ([[60. Collections/63. Meetings/]])
- Connect to relevant expertise ([[📚 831 Consulting]])
- Reference applicable frameworks ([[📖 200 Literature]])
- Consider deliverables ([[📚 830 Projects]])

### Content Creation Context
If creating content:
- Identify target platform ([[📚 701 YouTube]], [[📚 802 Articles]], etc.)
- Reference source knowledge ([[📖 200 Literature]], [[📖 600 Specialties]])
- Use prompt templates ([[📚 492 Prompts]])
- Consider audience and purpose

### Knowledge Management Context
If discussing PKM system itself:
- Reference [[🏛 CMDS Guide]] for standards
- Consider [[📚 601 Knowledge Management]] best practices
- Think about Obsidian workflows ([[📚 501 Obsidian]])
- Apply Second Brain principles ([[📚 603 Second Brain]])

---

## Working with the CMDS System

### When Creating New Notes
1. Determine the **CMDS category** (100-900 series) based on content type
2. Use appropriate **note type** (note, meeting, curriculum, etc.)
3. Add required **properties** (type, aliases, author, date created, tags)
4. Link to relevant **index notes** (🏷)
5. Reference related **CMDS categories**
6. Create **backlinks** to related notes

### When Organizing Information
- **Connect Stage** → Capture in [[📖 100 Themes]]
- **Merge Stage** → Integrate into [[📖 200 Literature]]
- **Develop Stage** → Apply in [[📖 300 Data]] through [[📖 600 Specialties]]
- **Share Stage** → Output via [[📖 700 Creatives]] or [[📖 800 Outputs]]

### When Searching for Context
Look for relevant notes in:
1. **Index pages** (🏷) — Aggregated collections
2. **Hub pages** (🏛) — Main navigation
3. **CMDS categories** (📖, 📚) — Topical organization
4. **Daily/Weekly notes** — Temporal context
5. **Meeting notes** — Project context
6. **People notes** — Relationship context

---

## Vault Statistics (as of 2025-01-09)

- **Total Notes**: 5,344+
- **CMDS Categories**: 9 main (100-900) + 91 sub-categories
- **Templates**: 94 note templates
- **Obsidian Plugins**: 120+
- **Note Types**: 142+ `note`, 101+ `terminology`, 80+ `meeting`, 59+ `people`, 60+ `CMDS`
- **Years Active**: 2+ years of continuous knowledge accumulation

This is a **mature, established system** with well-defined patterns. Respect existing conventions and structures.

---

## Guiding Principles

1. **Every note has a home**: All knowledge belongs somewhere in the 100-900 system
2. **Links create value**: Isolated notes are less useful than connected notes
3. **Process matters**: Knowledge flows through Connect → Merge → Develop → Share
4. **Output is the goal**: Knowledge exists to serve others through outputs
5. **AI is a partner**: AI tools enhance but don't replace human thinking
6. **Standards enable freedom**: Consistent structure allows creative flexibility
7. **Evolution over perfection**: The system grows and adapts continuously

---

## Quick Reference: When to Use Which Category

| If you're working with... | Use Category... | Subcategory Examples |
|---------------------------|-----------------|---------------------|
| New ideas, emerging topics | 📖 100 Themes | 102 Topics, 103 Variables |
| Books, papers, theories | 📖 200 Literature | 210 Literature Reviews, 240 Books |
| Survey data, datasets | 📖 300 Data | 302 Questionnaires, 310 Data Management |
| Analysis methods, code | 📖 400 Methodologies | 420 Machine Learning, 491 Codes, 492 Prompts |
| Software tools, AI platforms | 📖 500 Products | 501 Obsidian, 520 ChatGPT, 521 Claude |
| Domain expertise, skills | 📖 600 Specialties | 601 Knowledge Management, 620 Generative AI |
| Creative content | 📖 700 Creatives | 701 YouTube, 720 Music |
| Publications, deliverables | 📖 800 Outputs | 801 PhD, 840 Lectures, 831 Consulting |
| Business operations | 📖 900 Divisions | 901-909 (specific divisions) |

---

**Remember**: CMDS is not just a filing system—it's a **thinking environment** where 구요한 develops ideas, conducts research, creates content, and serves others. When working with this vault, you're not just organizing files; you're supporting a knowledge worker's entire professional ecosystem.

**For technical implementation details, file operations, and coding guidelines, see [[CLAUDE.md]].**
